$(function () {
	var offset = 300,
		duration = 500,
		top_section = $('.to-top'),
		toTopButton = $('a.back-to-top');
	// showing and hiding button according to scroll amount (in pixels)
	$(window).scroll(function () {
		if ($(this).scrollTop() > offset) {
			$(top_section).fadeIn(duration);
		} else {
			$(top_section).fadeOut(duration);
		}
	});
	// activate smooth scroll to top when clicking on the button
	$(toTopButton).click(function (e) {
		e.preventDefault();
		$('html, body').animate({
			scrollTop: 0
		}, 700);
	});
});

$(function () {
	// This will select everything with the class smoothScroll
	// This should prevent problems with carousel, scrollspy, etc...
	$('.smoothScroll').click(function () {
		if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname) {
			var target = $(this.hash);
			target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
			if (target.length) {
				$('html,body').animate({
					scrollTop: target.offset().top - 80
				}, 500); // The number here represents the speed of the scroll in milliseconds
				return false;
			}
		}
	});
});
