$(document).ready(function() {

    let currentIndex = 0;

    const slides = $('.slide');

    const slideCount = slides.length;

    const slideInterval = 4000;



    function showNextSlide() {

        slides.eq(currentIndex).removeClass('active');

        currentIndex = (currentIndex + 1) % slideCount;

        slides.eq(currentIndex).addClass('active');

    }



    slides.eq(currentIndex).addClass('active');

    setInterval(showNextSlide, slideInterval);

});





let currentIndex = 0;

const itemsPerSlide = 3;



function showSlide(index) {

    const slides = document.querySelectorAll('.service-box');

    

    // Hide all service boxes

    slides.forEach((slide, i) => {

        slide.style.display = 'none';

        slide.classList.remove('show');  // Remove the 'show' class to hide the slide

    });

    

    // Show only the required service boxes (3 boxes per slide) and add the 'show' class

    for (let i = index * itemsPerSlide; i < (index + 1) * itemsPerSlide; i++) {

        if (slides[i]) {

            slides[i].style.display = 'block';

            setTimeout(() => {

                slides[i].classList.add('show'); // Add the 'show' class for the fade-in and slide effect

            }, 100);  // Delay to allow the display change before animation starts

        }

    }

}



function moveSlide(step) {

    const slides = document.querySelectorAll('.service-box');

    const totalSlides = Math.ceil(slides.length / itemsPerSlide);

    currentIndex += step;



    if (currentIndex < 0) {

        currentIndex = totalSlides - 1;

    } else if (currentIndex >= totalSlides) {

        currentIndex = 0;

    }



    showSlide(currentIndex);

}



// Autoplay functionality (next slide every 5 seconds)

setInterval(() => {

    moveSlide(1);

}, 5000);  // 5000ms = 5 seconds



// Initialize the first set of service boxes to be shown (show first 3 boxes initially)

document.addEventListener('DOMContentLoaded', function () {

    showSlide(currentIndex);

});







document.addEventListener("DOMContentLoaded", function () {

  let currentIndex = 0;

  const images = document.querySelectorAll('.newlocation.location-find-images .image-slider img');

  const totalImages = images.length;



  images[currentIndex].classList.add('active');



  function changeImage() {

    images[currentIndex].classList.remove('active');

    currentIndex = (currentIndex + 1) % totalImages;

    images[currentIndex].classList.add('active');

  }



  setInterval(changeImage, 3000);

});




document.addEventListener("DOMContentLoaded", function () {
    let currentIndex = 0;
    const slides = document.querySelectorAll(".service-slider img");
    const totalSlides = slides.length;
    const intervalTime = 3000; // Change slide every 3 seconds

    function showSlide(index) {
        slides.forEach((slide, i) => {
            slide.style.display = i === index ? "block" : "none";
        });
    }

    function moveSlide(step) {
        currentIndex = (currentIndex + step + totalSlides) % totalSlides;
        showSlide(currentIndex);
    }

    function autoSlide() {
        moveSlide(1);
    }

    showSlide(currentIndex);
    document.querySelector(".service-prev").addEventListener("click", () => moveSlide(-1));
    document.querySelector(".service-next").addEventListener("click", () => moveSlide(1));

    // Auto slide
    setInterval(autoSlide, intervalTime);
});


