<!-- Start Enquiry Modal -->
<div class="modal fade ed-auth__modal" id="registerModal" tabindex="-1" aria-labelledby="enquiryFormLabel" aria-hidden="true">
  <div class="modal-dialog" style="max-width: 500px;">
    <div class="ed-auth__modal-content modal-content position-relative">
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      <div class="p-4">
        <h5 class="text-center mb-3">Enquiry Form</h5>
        <form action="mail.php" method="POST" class="recaptcha-form ed-contact__form-main">
          <div class="mb-3">
            <input type="text" name="name" class="form-control" placeholder="Full Name" required />
          </div>
          <div class="mb-3">
            <input type="email" name="email" class="form-control" placeholder="Email Address" required />
          </div>
          <div class="mb-3">
            <input type="tel" name="phone" class="form-control" placeholder="Phone Number" maxlength="10" required
              oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10);" />
          </div>
          <div class="mb-3">
            <textarea name="message" class="form-control" placeholder="Your Message" rows="3" required></textarea>
          </div>
          <input type="hidden" name="recaptcha_response" class="recaptcha-token">
          <div class="d-grid">
            <button type="submit" class="btn btn-primary">Send Enquiry</button>
          </div>
        </form>
        <script src="https://www.google.com/recaptcha/api.js?render=6LeFZT0rAAAAAGZN58j_eL7Da-WVEn0-JYXnnTQr"></script>
                            <script>
                                document.addEventListener('DOMContentLoaded', function() {
                                    document.querySelectorAll('.recaptcha-form').forEach(form => {
                                        form.addEventListener('submit', function(e) {
                                            e.preventDefault();

                                            if (form.checkValidity()) {
                                                grecaptcha.ready(function() {
                                                    grecaptcha.execute('6LeFZT0rAAAAAGZN58j_eL7Da-WVEn0-JYXnnTQr', {
                                                            action: 'submit'
                                                        })
                                                        .then(function(token) {
                                                            form.querySelector('.recaptcha-token').value = token;
                                                            form.submit();
                                                        });
                                                });
                                            } else {
                                                form.reportValidity();
                                            }
                                        });
                                    });
                                });
                            </script>
      </div>
    </div>
  </div>
</div>
<!-- End Enquiry Modal -->

<!-- Popup Auto Launch Script -->
<script>
  document.addEventListener("DOMContentLoaded", function () {
    const path = window.location.pathname;
    const page = path.substring(path.lastIndexOf("/") + 1);

    if (page === "index.php" || page === "") {
      const registerModal = new bootstrap.Modal(document.getElementById('registerModal'));

      // Show immediately once
      registerModal.show();

      // Then show every 60 seconds
      setInterval(function () {
        registerModal.show();
      }, 60000); // 60,000 ms = 60 seconds
    }
  });
</script>


<!-- Inline CSS Styling -->
<style>
  .ed-auth__modal-content {
    border-radius: 12px;
    box-shadow: 0 8px 30px rgba(0, 0, 0, 0.25);
    border: none;
    background-color: #fff;
  }

  .form-control {
    border-radius: 8px;
    border: 1px solid #ccc;
    padding: 10px;
    font-size: 15px;
  }

  .form-control:focus {
    border-color: #003366;
    box-shadow: 0 0 4px rgba(0, 51, 102, 0.2);
  }

  .btn-primary {
    background-color: #003366;
    border: none;
    border-radius: 8px;
    padding: 10px;
    font-weight: bold;
  }

  .btn-primary:hover {
    background-color: #0055a5;
  }

  .btn-close {
    position: absolute;
    top: 10px;
    right: 10px;
    z-index: 10;
  }

  @media (max-width: 576px) {
    .modal-dialog {
      margin: 1rem auto;
      width: 90%;
    }

    .p-4 {
      padding: 1.5rem !important;
    }

    .form-control {
      font-size: 14px;
    }
  }
</style>

