<!DOCTYPE html>
<html lang="en">

<head>
    <!-- meta tags -->
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="keywords" content="">

    <!-- title -->
    <title>Bayaluseeme Development Board</title>

    <!-- favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon.png">

    <!-- css -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/all-fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/owl.carousel.min.css">
    <link rel="stylesheet" href="assets/css/style.css">

</head>

<body class="home-3">

    <!-- preloader -->
    <!-- <div class="preloader">
        <div class="loader-book">
            <div class="loader-book-page"></div>
            <div class="loader-book-page"></div>
            <div class="loader-book-page"></div>
        </div>
    </div> -->
    <!-- preloader end -->

    <div class="translater">
        <select id="languageSelector" onchange="translateLanguage()">
            <option value="en">English</option>
            <option value="kn">Kannada</option>
        </select>
    </div>

    <script type="text/javascript">
        function translateLanguage() {
            var language = document.getElementById("languageSelector").value;
            var currentURL = window.location.href;

            if (language === "en") {
                window.location.href = currentURL.split("#googtrans")[0]; // Reset to English
            } else {
                window.location.href = currentURL + "#googtrans(en|" + language + ")";
                window.location.reload();
            }
        }

        function googleTranslateElementInit() {
            new google.translate.TranslateElement({
                    pageLanguage: 'en',
                    includedLanguages: 'kn,en',
                    autoDisplay: false
                },
                'google_translate_element'
            );
        }
    </script>

    <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>


    <!-- header area -->
    <header class="header">

        <!-- header top -->
        <div class="header-top">
            <div class="container">
                <div class="header-top-wrap">
                    <div class="header-top-left">
                        <img src="assets/img/logo.png" class="header-logo" alt="logo">
                    </div>
                    <div>
                        <h2 class="logo-title text-center">
                            Government of Karnataka
                            Bayaluseeme Development Board
                            Chitradurga - Karnataka
                        </h2>
                    </div>
                    <div class="header-top-right">
                        <img src="assets/img/logo-1.png" class="header-logo" alt="logo">
                    </div>
                </div>
            </div>
        </div>
        <div class="main-navigation">
            <nav class="navbar navbar-expand-lg">
                <div class="container-fluid position-relative justify-content-center">


                    <div class="mobile-menu-right">

                        <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                            data-bs-target="#main_nav" aria-expanded="false" aria-label="Toggle navigation">
                            <span class="navbar-toggler-mobile-icon"><i class="far fa-bars"></i></span>
                        </button>


                    </div>
                    <div class="collapse navbar-collapse" id="main_nav">
                        <ul class="navbar-nav">
                            <li class="nav-item "><a class="nav-link  active" href="index.php">Home</a></li>

                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">About Us</a>
                                <ul class="dropdown-menu fade-down">
                                    <li><a class="dropdown-item" href="introduction.php">Introduction</a></li>
                                    <li><a class="dropdown-item" href="vision-mission.php">Vision & Mission</a></li>
                                    <li><a class="dropdown-item" href="organization-structure.php">Organization Structure</a></li>
                                    <li><a class="dropdown-item" href="board-administration.php">Board Administration</a></li>
                                    <li><a class="dropdown-item" href="constitution.php">Constitution</a></li>
                                    <li><a class="dropdown-item" href="implementing-agencies.php">Implementing Agencies</a></li>
                                </ul>
                            </li>

                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">Archives </a>
                                <ul class="dropdown-menu fade-down">
                                    <li><a class="dropdown-item" href="assets/img/archives/2021-22 Admin Report.pdf" target="_blank">Administrative Report 2021-22</a></li>
                                    <li><a class="dropdown-item" href="#">Administrative Report 2020-21</a></li>
                                </ul>
                            </li>


                            <li class="nav-item"><a class="nav-link" href="annual-reports.php">Annual Reports</a></li>

                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">Planning </a>
                                <ul class="dropdown-menu fade-down">
                                    <li><a class="dropdown-item" href="action-plans.php">Action Plans</a></li>
                                </ul>
                            </li>
                            <li class="nav-item"><a class="nav-link" href="circulars.php">Circulars</a></li>

                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">Gallery </a>
                                <ul class="dropdown-menu fade-down">
                                    <li><a class="dropdown-item" href="gallery.php">Gallery</a></li>
                                    <li><a class="dropdown-item" href="tourist-place.php">Tourist Place</a></li>

                                </ul>
                            </li>

                            <li class="nav-item"><a class="nav-link" href="tender-notification.php">Tender Notification</a></li>

                            <li class="nav-item"><a class="nav-link" href="contact-us.php">Contact Us</a></li>

                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">RTI </a>
                                <ul class="dropdown-menu fade-down">
                                    <li><a class="dropdown-item" href="#">RTI </a></li>
                                    <li><a class="dropdown-item" href="#">Officer Details </a></li>
                                    <li><a class="dropdown-item" href="#">4(1)A </a></li>
                                    <li><a class="dropdown-item" href="#">4(1)B </a></li>

                                </ul>
                            </li>

                        </ul>

                    </div>
                </div>
            </nav>
        </div>
    </header>
    <!-- header area end -->