<?php include 'header.php';
include 'admin/config.php';
?>


<!-- breadcrumb -->
<div class="site-breadcrumb" style="background: url(assets/img/home/s0.png)">
    <div class="container">
        <h2 class="breadcrumb-title">RTI</h2>
        <ul class="breadcrumb-menu">
            <li><a href="index.php">Home</a></li>
            <li class="active">RTI</li>
        </ul>
    </div>
</div>
<!-- breadcrumb end -->

<!-- course-area -->
<div class="course-area py-80">
    <div class="container">
        <div class=" text-center mt-5 mb-4">
            <h2 class="mb-3">
                RTI
            </h2>

        </div>
        <div class="table-responsive">
            <table class="table annual-report text-center table-bordered">
                <thead>

                    <tr class="table-primary ">
                        <th scope="col">Title</th>
                        <th scope="col">Date</th>
                        <th scope="col">Description</th>
                        <th scope="col">Address</th>
                        <th scope="col">View / Download</th>
                    </tr>
                </thead>
                <tbody class="">
                    <?php
                    $sql = "SELECT * FROM `rti` ORDER BY STR_TO_DATE(date, '%d-%m-%Y') DESC"; // Convert and order by date
                    $query = mysqli_query($con, $sql);
                    if ($query) {
                        while ($row = mysqli_fetch_assoc($query)) {
                            $title = $row['title'];
                            $date = date("d-m-Y", strtotime(str_replace('/', '-', $row['date']))); // Ensure date format
                            $description = $row['description'];
                            $address = $row['address'];
                            $pdf = $row['document'];
                            $pdf_path = "admin/image/" . $pdf;
                    ?>
                            <tr>
                                <td><?php echo $title; ?></td>
                                <td><?php echo $date; ?></td>
                                <td><?php echo $description; ?></td>
                                <td><?php echo $address; ?></td>
                                <td><a href="<?php echo $pdf_path; ?>" target="_blank"><i class="fa-solid fa-file-arrow-down"></i></a></td>
                            </tr>
                    <?php
                        }
                    }
                    ?>


                </tbody>
            </table>
        </div>


    </div>
</div>
<!-- course-area -->


<?php include 'footer.php' ?>