var tweetajax   =	true;
var target		=	'';
CKEDITOR.dialog.add( 'embedtweet', function( editor ) {
	var getTweet 	=	function(method, tweet){
		var data	=	'';
		if (tweetajax){
			$.ajax({
				url: method,
				async: false,
				type: 'POST',
				dataType: 'json',
				data: 'tweetURL='+tweet,
				headers: { 'X-CSRF-TOKEN': parent.$("meta[name=csrf-token]").attr("content") },
				beforeSend: function(){
					tweetajax 	=	false;
					$('.tmessage').html('<div class="embedloader">Please wait...</div>')
					$('.tmessage').show();
				},
				success: function(response) {
					data	=	response;
				},
				error: function(){ tweetajax 	=	true; },
				complete: function(){ 
					tweetajax 	=	true;
					$('.tmessage').hide();
				}
			});
		}
		return data;
	};
	var trim	=	function(inputString) {
		if (typeof inputString != "string") { return inputString; }
		var retValue = inputString;
		var ch = retValue.substring(0, 1);
		while (ch == " ") {
			retValue = retValue.substring(1, retValue.length);
			ch = retValue.substring(0, 1);
		}
		ch = retValue.substring(retValue.length-1, retValue.length);
		while (ch == " ") {
			retValue = retValue.substring(0, retValue.length-1);
			ch = retValue.substring(retValue.length-1, retValue.length);
		}
		while (retValue.indexOf("  ") != -1) { 
			retValue = retValue.substring(0, retValue.indexOf("  ")) + retValue.substring(retValue.indexOf("  ")+1, retValue.length);
		}
		return retValue;
	};
	
    return {
        title: 'Embed Tweet',
        minWidth: 300,
        minHeight: 100,
        onOk: function() {
        	window.parent.CKupdate();
        },
        contents: [
            {
                id: 'info',
                elements: [
                    {
                        id: 'search',
                        type: 'text',
                        label: 'Enter Tweet URL',
                    	required : true,
                    	validate: function(element){
                    		$('.tmessage').hide();
                    		if (trim(this.getValue())=='')
                    		{	
                    			$('.tmessage').html('Please enter the tweet URL');
                    			$('.tmessage').show();
                    			return false;
                    		}
                    		else{
                    			$('.tmessage').hide();
                    			var _Call 	=	editor.config.customValues.name;
                    			tweet		=	getTweet(_Call, this.getValue());
                    			if (!tweet.status){
                    				$('.tmessage').html(tweet.message);
                    				$('.tmessage').show();
                    				return false;
                    			}
                    			target	=	tweet.embedcode;
                    		}
                    	},
                        setup: function(widget) {
                        	this.setValue( widget.data.blockqoute);
                        },
                        commit: function(widget) {
                        	widget.setData( 'blockqoute', target);
                        }
                    },
                    {
                        id: 'tweets',
                        type: 'html',
                    	html : '<div class="tmessage"></div>' 
                    },
                ]
            }
        ],
        buttons: [  	CKEDITOR.dialog.okButton, 
                    	CKEDITOR.dialog.cancelButton],
    };
} );
