CKEDITOR.plugins.add('embedbrightcove',{
	icons: 'embedbrightcove',
	init : function(editor){
		editor.addCommand( 'embedBrightcoveDialog', new CKEDITOR.dialogCommand( 'embedBrightcoveDialog' ) );
		editor.ui.addButton('embedbrightcove',{
			label   : "insert brightcove link",
			command : 'embedBrightcoveDialog',
			toolbar : 'Insert'
		})
		editor.addContentsCss(this.path + "css/embedbrightcove.css");
		CKEDITOR.dialog.add( 'embedBrightcoveDialog', function( editor )
		{
			return {
				title : 'Link Properties',
				minWidth : 400,
				minHeight : 100,
				contents :
				[
					{
						id : 'general',
						label : 'Settings',
						elements :
						[
						 	{
								type : 'html',
								html : 'enter brightcove video url'		
							},
							{
								type : 'text',
								id : 'url',
								label : 'URL',
								validate : CKEDITOR.dialog.validate.notEmpty( 'The link must have a URL.' ),
								required : true,
								commit : function( data )
								{
									data.url = this.getValue();
								}
							},
							{
								type : 'text',
								id : 'width',
								label : 'Width',
								default : 600,
								width : '120px;',
								validate : CKEDITOR.dialog.validate.notEmpty( 'fill video width' ),
								required : true,
								commit : function( data )
								{
									data.width = this.getValue();
								}
							},
							{
								type : 'text',
								id : 'height',
								label : 'Hieght',
								default : 540,
								width : '120px;',
								validate : CKEDITOR.dialog.validate.notEmpty( 'fill video width' ),
								required : true,
								commit : function( data )
								{
									data.height = this.getValue();
								}
							},
						]
					}
				],
				onOk : function()
				{
					var dialog = this,
					data = {},
					//div = editor.document.createElement( 'div' );
					//div.addClass('embedbrightcove-container');
					iframe = editor.document.createElement( 'iframe' );
					iframe.addClass('embedbrightcove-style');	
					this.commitContent( data );
					iframe.setAttribute( 'src', data.url );
					iframe.setAttribute('allow','encrypted-media');
					iframe.setAttribute('allowfullscreen');
					iframe.setAttribute('width',data.width);
					iframe.setAttribute('height',data.height);
					//div.append(iframe);
					editor.insertElement( iframe );
				}
			};
		});
		
	}
})
